
```dataviewjs

const jsonFilePath = "/maps/plugins/obsidian-leaflet-plugin/data.json";
let markersTable;

try {
    const mapJsonString = await dv.io.load(jsonFilePath);
    const mapJsonObject = JSON.parse(mapJsonString);

    if (mapJsonObject.mapMarkers) {
        markersTable = dv.table(["Map ID", "Marker ID", "Type", "Lat", "Long"],
            mapJsonObject.mapMarkers.flatMap(map => 
                map.markers.map(marker => [
                    map.id, // Map ID
                    marker.id, // Marker ID
                    marker.type,
                    marker.loc[0], // Lat
                    marker.loc[1], // Long
                ])
            )
        );
    } else {
        markersTable = dv.table(["Error"], [["Invalid JSON format - No mapMarkers property found"]]);
    }
} catch (error) {
    markersTable = dv.table(["Error"], [[`Error parsing JSON: ${error.message}`]]);
}

```
